/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HSCIProvWithRecoveryPlugin;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.InSysProfileInstProv;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscLockManager;
import com.ibm.hsc.common.util.HscPerformance;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.ProviderLceCommunication;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbemcfg.GlobalConfig;

public class LPARProfileInstProv
extends HSCIProvWithRecoveryPlugin
implements InstanceProvider {
    private static final int ProfileProviderDebug = 3;

    public LPARProfileInstProv() {
        super(false, null, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMObjectPath cIMObjectPath2;
        int n = HscPerformance.startTransaction("LPARProfileInstProv+createInstance");
        System.out.println("####In LparProfileInstProv#####");
        String string = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
        String string2 = string.substring(string.indexOf(42) + 1);
        System.out.println("The cec name is #####:" + string2);
        System.out.println("##### Obtaining the lock #####");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string2);
        if (hscCecLock == null) {
            System.out.print("######fail to get ceclock\n");
        }
        try {
            hscCecLock.Lock(hscLockManager.getLockType("createInstance"));
            cIMObjectPath2 = super.createInstance(cIMObjectPath, cIMInstance);
            Object var10_9 = null;
            System.out.println("##### Releasing the lock #####");
            hscCecLock.Unlock();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            System.out.println("##### Releasing the lock #####");
            hscCecLock.Unlock();
            HscPerformance.endTransaction(n);
            throw throwable;
        }
        HscPerformance.endTransaction(n);
        return cIMObjectPath2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath createInstance0(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMInstance cIMInstance2 = null;
        Hashtable hashtable = null;
        Vector<CIMProperty> vector = null;
        HscProviderSocket hscProviderSocket = null;
        String string = null;
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("LPARProfile InstanceProvider - createInstance");
        }
        Trace.trace("appphscT", "-> createInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("createInstance - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("appphscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("createInstance - CIMInstance  = " + cIMInstance);
        }
        Trace.trace("appphscF", "CIMInstance = " + cIMInstance);
        String string2 = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ncreateInstance - PartitionName = " + string2);
        }
        Trace.trace("appphscD", "PartitionName = " + string2);
        String string3 = string2.substring(string2.indexOf(42) + 1);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ncreateInstance - CECName = " + string3);
        }
        Trace.trace("appphscD", "CECName = " + string3);
        String string4 = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
        short s = Short.parseShort(string2.substring(0, 3));
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ncreateInstance - partitionID = " + s);
        }
        Trace.trace("appphscD", "partitionID = " + s);
        if (s == 0) {
            throw new HSCCIMException("07D5");
        }
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ncreateInstance - LCESocket = " + hscProviderSocket);
            }
            Trace.trace("appphscF", "Obtained LCESocket");
            hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"1", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (hashtable == null) {
                throw new HSCCIMException("01F5");
            }
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ncreateInstance - Locked CSP");
            }
            Trace.trace("appphscF", "Locked CSP");
            if (((NVRAM)NVRAM.NVRAM_TABLE.get(string3)).isDuplicatedAtPartition(s, string4, hscProviderSocket)) {
                throw new HSCCIMException("07D4", new String[]{string4});
            }
            hashtable = null;
            hashtable = HscProviderUtils.doCSPCommand("GET_CEC_TIME_OF_DAY", null, hscProviderSocket);
            if (hashtable == null) {
                throw new HSCCIMException("01F7");
            }
            string = new String(NVRAM.printableTimestamp(new String(((NVRAM)NVRAM.NVRAM_TABLE.get(string3)).getTime(hashtable))));
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ncreateInstance - SettingID = " + string);
            }
            Trace.trace("appphscD", "SettingID = " + string);
            cIMInstance.setProperty("SettingID", new CIMValue((Object)string));
            Thread.sleep(1000L);
            vector = new Vector<CIMProperty>();
            cIMObjectPath3 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            cIMObjectPath3.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath3.addKey("Name", new CIMValue((Object)string3));
            cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath3, new CIMClass("IBMHSC_Partition"), false);
            if ((float)VersionComparator.CSPVersionValue((String)cIMInstance2.getProperty("CSPVersion").getValue().getValue()) < 3000.0f) {
                vector.setSize(11);
                vector.setElementAt(cIMInstance.getProperty("SettingID"), 0);
                vector.setElementAt(cIMInstance.getProperty("UserDefinedName"), 1);
                vector.setElementAt(cIMInstance.getProperty("BootMode"), 2);
                vector.setElementAt(cIMInstance.getProperty("ServiceAuthority"), 3);
                vector.setElementAt(cIMInstance.getProperty("DesiredCPUCount"), 4);
                vector.setElementAt(cIMInstance.getProperty("MinimumCPUCount"), 5);
                vector.setElementAt(cIMInstance.getProperty("DesiredMemoryMB"), 6);
                vector.setElementAt(cIMInstance.getProperty("MinimumMemoryMB"), 7);
                vector.setElementAt(cIMInstance.getProperty("IODrawer"), 8);
                vector.setElementAt(cIMInstance.getProperty("IOSlots"), 9);
                vector.setElementAt(cIMInstance.getProperty("IORequirement"), 10);
            } else {
                if ((float)VersionComparator.CSPVersionValue((String)cIMInstance2.getProperty("CSPVersion").getValue().getValue()) > 3000.0f) {
                    vector.setSize(18);
                    vector.setElementAt(cIMInstance.getProperty("SNIConfigMode"), 15);
                    vector.setElementAt(cIMInstance.getProperty("SNIDeviceID"), 16);
                    vector.setElementAt(cIMInstance.getProperty("SNIWindows"), 17);
                } else {
                    vector.setSize(15);
                }
                vector.setElementAt(cIMInstance.getProperty("SettingID"), 0);
                vector.setElementAt(cIMInstance.getProperty("UserDefinedName"), 1);
                vector.setElementAt(cIMInstance.getProperty("BootMode"), 2);
                vector.setElementAt(cIMInstance.getProperty("ServiceAuthority"), 3);
                vector.setElementAt(cIMInstance.getProperty("RMOSize"), 4);
                vector.setElementAt(cIMInstance.getProperty("SFPSurveillance"), 5);
                vector.setElementAt(cIMInstance.getProperty("DesiredCPUCount"), 6);
                vector.setElementAt(cIMInstance.getProperty("MinimumCPUCount"), 7);
                vector.setElementAt(cIMInstance.getProperty("MaximumCPUCount"), 8);
                vector.setElementAt(cIMInstance.getProperty("DesiredMemoryMB"), 9);
                vector.setElementAt(cIMInstance.getProperty("MinimumMemoryMB"), 10);
                vector.setElementAt(cIMInstance.getProperty("MaximumMemoryMB"), 11);
                vector.setElementAt(cIMInstance.getProperty("IODrawer"), 12);
                vector.setElementAt(cIMInstance.getProperty("IOSlots"), 13);
                vector.setElementAt(cIMInstance.getProperty("IORequirement"), 14);
            }
            ((NVRAM)NVRAM.NVRAM_TABLE.get(string3)).createLPARProfile(s, string4, string, vector, hscProviderSocket);
            try {
                HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_LPAR_PROFILE_CREATE", new String[]{"0", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle), "4", "1", Integer.toHexString(s), string}, hscProviderSocket);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            }
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
                    if (GlobalConfig.debugLevel((int)3) > 0) {
                        System.out.println("\ncreateInstance - Unlocked CSP");
                    }
                    Trace.trace("appphscF", "Unlocked CSP");
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    HSCLogUtils.serverLog(throwable3, HSCLogUtils._ProfileClassLogInfo);
                    throw new HSCCIMException("01F6");
                }
                finally {
                    try {
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                        }
                        if (GlobalConfig.debugLevel((int)3) > 0) {
                            System.out.println("\ncreateInstance - Released LCESocket");
                        }
                        Trace.trace("appphscF", "Released LCESocket");
                    }
                    catch (Throwable throwable4) {
                        HSCLogUtils.serverLog(throwable4, HSCLogUtils._ProfileClassLogInfo);
                    }
                }
            }
        }
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ncreateInstance - Unlocked CSP");
            }
            Trace.trace("appphscF", "Unlocked CSP");
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            throw new HSCCIMException("01F6");
        }
        finally {
            try {
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
                if (GlobalConfig.debugLevel((int)3) > 0) {
                    System.out.println("\ncreateInstance - Released LCESocket");
                }
                Trace.trace("appphscF", "Released LCESocket");
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            }
        }
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ncreateInstance - Wrote new profile to NVRAM");
        }
        cIMObjectPath = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
        cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
        cIMObjectPath2 = CimomWrapper.createInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance);
        CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
        cIMObjectPath4.addKey("Name", new CIMValue((Object)string2));
        cIMObjectPath4.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
        CIMObjectPath cIMObjectPath5 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
        cIMObjectPath5.addKey("SettingID", new CIMValue((Object)string));
        cIMObjectPath5.addKey("PartitionName", new CIMValue((Object)string2));
        cIMObjectPath5.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
        CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
        CIMClass cIMClass = this.mCIMOMHandle.getClass(cIMObjectPath6, false);
        CIMInstance cIMInstance3 = cIMClass.newInstance();
        cIMInstance3.setProperty("Element", new CIMValue((Object)cIMObjectPath4));
        cIMInstance3.setProperty("Setting", new CIMValue((Object)cIMObjectPath5));
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ncreateInstance = adding to PartitionProfile " + cIMInstance3);
        }
        cIMObjectPath6.setKeys(cIMInstance3.getKeyValuePairs());
        CimomWrapper.createInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath6, cIMInstance3);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ncreateInstance -  return CIMObjectPath = " + cIMObjectPath2);
        }
        Trace.trace("appphscF", "returned CIMObjectPath = " + cIMObjectPath2);
        try {
            AsynchEventManager.sendIndication(1, cIMInstance, null);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
        }
        Trace.trace("appphscT", "<- createInstance");
        if (GlobalConfig.debugLevel((int)3) <= 0) return cIMObjectPath2;
        System.out.print("********************************");
        System.out.println("********************************");
        return cIMObjectPath2;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        int n = HscPerformance.startTransaction("LPARProfileInstProv+createInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("LPARProfile InstanceProvider - enumInstances");
        }
        Trace.trace("appphscT", "-> enumInstances");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("enumInstances - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("appphscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("enumInstances - boolean = " + bl);
        }
        Trace.trace("appphscF", "boolean = " + bl);
        Vector vector = CimomWrapper.enumInstances((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, bl, cIMClass);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("enumInstances - Return Vector = " + vector);
        }
        Trace.trace("appphscF", "return Vector = " + vector);
        Trace.trace("appphscT", "<- enumInstances");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        HscPerformance.endTransaction(n);
        return vector;
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        int n = HscPerformance.startTransaction("LPARProfileInstProv+createInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("LPARProfile InstanceProvider - enumInstances");
        }
        Trace.trace("appphscT", "-> enumInstances");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("enumInstances - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("appphscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("enumInstances - boolean = " + bl);
        }
        Trace.trace("appphscF", "boolean = " + bl);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("enumInstances - boolean = " + bl2);
        }
        Trace.trace("appphscF", "boolean = " + bl2);
        Vector vector = CimomWrapper.enumInstances((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, bl, cIMClass, bl2);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("enumInstances - Return Vector = " + vector);
        }
        Trace.trace("appphscF", "return Vector = " + vector);
        Trace.trace("appphscT", "<- enumInstances");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        HscPerformance.endTransaction(n);
        return vector;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        int n = HscPerformance.startTransaction("LPARProfileInstProv+createInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("LPARProfile InstanceProvider - getInstance");
        }
        Trace.trace("appphscT", "-> getInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("getInstance - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("appphscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("getInstance - boolean = " + bl);
        }
        Trace.trace("appphscF", "boolean = " + bl);
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMClass, bl);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("getInstance - Return CIMInstance = " + cIMInstance);
        }
        Trace.trace("appphscF", "return CIMInstance = " + cIMInstance);
        Trace.trace("appphscT", "<- getInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
        HscPerformance.endTransaction(n);
        return cIMInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        int n = HscPerformance.startTransaction("LPARProfileInstProv+createInstance");
        System.out.println("####In deleteInstance ProfileInstProv#####");
        String string = HscProviderUtils.getCecNameFromProfileObjPath(cIMObjectPath, this.mCIMOMHandle);
        System.out.println("The cec name is #####:" + string);
        System.out.println("##### Obtaining the lock #####");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        if (hscCecLock == null) {
            System.out.print("######fail to get ceclock\n");
        }
        try {
            hscCecLock.Lock(hscLockManager.getLockType("deleteInstance"));
            super.deleteInstance(cIMObjectPath);
            Object var7_6 = null;
            System.out.println("##### Releasing the lock #####");
            hscCecLock.Unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            System.out.println("##### Releasing the lock #####");
            hscCecLock.Unlock();
            HscPerformance.endTransaction(n);
            throw throwable;
        }
        HscPerformance.endTransaction(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteInstance0(CIMObjectPath cIMObjectPath) throws CIMException {
        Hashtable hashtable = null;
        HscProviderSocket hscProviderSocket = null;
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("LPARProfile InstanceProvider - deleteInstance");
        }
        Trace.trace("appphscT", "-> deleteInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteInstance - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("appphscF", "CIMObjectPath = " + cIMObjectPath);
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_LparProfile"), false);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteInstance - ci = " + cIMInstance);
        }
        String string = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteInstance - PartitionName = " + string);
        }
        Trace.trace("appphscD", "PartitionName = " + string);
        String string2 = string.substring(string.indexOf(42) + 1);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteInstance - CECName = " + string2);
        }
        Trace.trace("appphscD", "CECName = " + string2);
        String string3 = (String)cIMInstance.getProperty("SettingID").getValue().getValue();
        short s = Short.parseShort(string.substring(0, 3));
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteInstance - partitionID = " + s);
        }
        Trace.trace("appphscD", "partitionID = " + s);
        if (s == 0) {
            throw new HSCCIMException("07D6");
        }
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string2);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ndeleteInstance - LCESocket = " + hscProviderSocket);
            }
            Trace.trace("appphscF", "Obtained LCESocket");
            hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"1", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (hashtable == null) {
                throw new HSCCIMException("01F5");
            }
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ndeleteInstance - Locked CSP");
            }
            Trace.trace("appphscF", "Locked CSP");
            LPARProfileInstProv.deleteProfile((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance, string2, string3, s, true, hscProviderSocket);
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
                    if (GlobalConfig.debugLevel((int)3) > 0) {
                        System.out.println("\ndeleteInstance - Unlocked CSP");
                    }
                    Trace.trace("appphscF", "Unlocked CSP");
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    HSCLogUtils.serverLog(throwable3, HSCLogUtils._ProfileClassLogInfo);
                    throw new HSCCIMException("01F6");
                }
                finally {
                    try {
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                        }
                        if (GlobalConfig.debugLevel((int)3) > 0) {
                            System.out.println("\ndeleteInstance - Released LCESocket");
                        }
                        Trace.trace("appphscF", "Released LCESocket");
                    }
                    catch (Throwable throwable4) {
                        HSCLogUtils.serverLog(throwable4, HSCLogUtils._ProfileClassLogInfo);
                    }
                }
            }
        }
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ndeleteInstance - Unlocked CSP");
            }
            Trace.trace("appphscF", "Unlocked CSP");
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            throw new HSCCIMException("01F6");
        }
        finally {
            try {
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
                if (GlobalConfig.debugLevel((int)3) > 0) {
                    System.out.println("\ndeleteInstance - Released LCESocket");
                }
                Trace.trace("appphscF", "Released LCESocket");
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            }
        }
        Trace.trace("appphscT", "<- deleteInstance");
        if (GlobalConfig.debugLevel((int)3) <= 0) return;
        System.out.print("********************************");
        System.out.println("********************************");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        int n = HscPerformance.startTransaction("LPARProfileInstProv+createInstance");
        System.out.println("####In setInst ProfileInstProv#####");
        String string = HscProviderUtils.getCecNameFromProfileObjPath(cIMObjectPath, this.mCIMOMHandle);
        System.out.println("The cec name is #####:" + string);
        System.out.println("##### Obtaining the lock #####");
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string);
        if (hscCecLock == null) {
            System.out.print("######fail to get ceclock\n");
        }
        try {
            hscCecLock.Lock(hscLockManager.getLockType("setInstance"));
            super.setInstance(cIMObjectPath, cIMInstance);
            Object var8_7 = null;
            System.out.println("##### Releasing the lock #####");
            hscCecLock.Unlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            System.out.println("##### Releasing the lock #####");
            hscCecLock.Unlock();
            HscPerformance.endTransaction(n);
            throw throwable;
        }
        HscPerformance.endTransaction(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInstance0(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        Hashtable hashtable = null;
        HscProviderSocket hscProviderSocket = null;
        Vector vector = null;
        Vector<CIMProperty> vector2 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance3 = null;
        Object var12_12 = null;
        String string = null;
        boolean bl = false;
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("LPARProfile InstanceProvider - setInstance");
        }
        Trace.trace("appphscT", "-> setInstance");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\nsetInstance - CIMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("appphscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\nsetInstance - CIMInstance = " + cIMInstance);
        }
        Trace.trace("appphscF", "CIMInstance = " + cIMInstance);
        CIMInstance cIMInstance2 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_LparProfile"), false);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\nsetInstance - m_ci = " + cIMInstance2);
        }
        String string2 = (String)cIMInstance2.getProperty("PartitionName").getValue().getValue();
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\nsetInstance - PartitionName = " + string2);
        }
        Trace.trace("appphscD", "PartitionName = " + string2);
        String string3 = string2.substring(string2.indexOf(42) + 1);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\nsetInstance - CECName = " + string3);
        }
        Trace.trace("appphscD", "CECName = " + string3);
        String string4 = (String)cIMInstance2.getProperty("SettingID").getValue().getValue();
        short s = Short.parseShort(string2.substring(0, 3));
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\nsetInstance - partitionID = " + s);
        }
        Trace.trace("appphscD", "partitionID = " + s);
        String string5 = (String)cIMInstance2.getProperty("UserDefinedName").getValue().getValue();
        if (s == 0) {
            throw new HSCCIMException("07D7");
        }
        String string6 = (String)cIMInstance2.getProperty("PartitionCreationClassName").getValue().getValue();
        if (!string2.equals((String)cIMInstance.getProperty("PartitionName").getValue().getValue())) throw new HSCCIMException("CIM_ERR_INVALID_PARAMETER");
        if (!string4.equals((String)cIMInstance.getProperty("SettingID").getValue().getValue())) throw new HSCCIMException("CIM_ERR_INVALID_PARAMETER");
        if (!string6.equals((String)cIMInstance.getProperty("PartitionCreationClassName").getValue().getValue())) {
            throw new HSCCIMException("CIM_ERR_INVALID_PARAMETER");
        }
        try {
            hscProviderSocket = ProviderLceCommunication.obtainSocket(string3);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\nsetInstance - LCESocket = " + hscProviderSocket);
            }
            Trace.trace("appphscF", "Obtained LCESocket");
            hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"1", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (hashtable == null) {
                throw new HSCCIMException("01F5");
            }
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\nsetInstance - CSP locked");
            }
            Trace.trace("appphscF", "Locked CSP");
            vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string3)).getLPARProfile(string4, hscProviderSocket);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\nsetInstance - ret = " + vector);
            }
            Trace.trace("appphscD", "ret = " + vector);
            if (vector == null) {
                throw new HSCCIMException("07D3");
            }
            vector2 = new Vector<CIMProperty>();
            cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath2.addKey("Name", new CIMValue((Object)string3));
            cIMInstance3 = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Partition"), false);
            if ((float)VersionComparator.CSPVersionValue((String)cIMInstance3.getProperty("CSPVersion").getValue().getValue()) < 3000.0f) {
                vector2.setSize(11);
                vector2.setElementAt(cIMInstance.getProperty("SettingID"), 0);
                vector2.setElementAt(cIMInstance.getProperty("UserDefinedName"), 1);
                vector2.setElementAt(cIMInstance.getProperty("BootMode"), 2);
                vector2.setElementAt(cIMInstance.getProperty("ServiceAuthority"), 3);
                vector2.setElementAt(cIMInstance.getProperty("DesiredCPUCount"), 4);
                vector2.setElementAt(cIMInstance.getProperty("MinimumCPUCount"), 5);
                vector2.setElementAt(cIMInstance.getProperty("DesiredMemoryMB"), 6);
                vector2.setElementAt(cIMInstance.getProperty("MinimumMemoryMB"), 7);
                vector2.setElementAt(cIMInstance.getProperty("IODrawer"), 8);
                vector2.setElementAt(cIMInstance.getProperty("IOSlots"), 9);
                vector2.setElementAt(cIMInstance.getProperty("IORequirement"), 10);
            } else {
                if ((float)VersionComparator.CSPVersionValue((String)cIMInstance3.getProperty("CSPVersion").getValue().getValue()) > 3000.0f) {
                    vector2.setSize(18);
                    vector2.setElementAt(cIMInstance.getProperty("SNIConfigMode"), 15);
                    vector2.setElementAt(cIMInstance.getProperty("SNIDeviceID"), 16);
                    vector2.setElementAt(cIMInstance.getProperty("SNIWindows"), 17);
                } else {
                    vector2.setSize(15);
                }
                vector2.setElementAt(cIMInstance.getProperty("SettingID"), 0);
                vector2.setElementAt(cIMInstance.getProperty("UserDefinedName"), 1);
                vector2.setElementAt(cIMInstance.getProperty("BootMode"), 2);
                vector2.setElementAt(cIMInstance.getProperty("ServiceAuthority"), 3);
                vector2.setElementAt(cIMInstance.getProperty("RMOSize"), 4);
                vector2.setElementAt(cIMInstance.getProperty("SFPSurveillance"), 5);
                vector2.setElementAt(cIMInstance.getProperty("DesiredCPUCount"), 6);
                vector2.setElementAt(cIMInstance.getProperty("MinimumCPUCount"), 7);
                vector2.setElementAt(cIMInstance.getProperty("MaximumCPUCount"), 8);
                vector2.setElementAt(cIMInstance.getProperty("DesiredMemoryMB"), 9);
                vector2.setElementAt(cIMInstance.getProperty("MinimumMemoryMB"), 10);
                vector2.setElementAt(cIMInstance.getProperty("MaximumMemoryMB"), 11);
                vector2.setElementAt(cIMInstance.getProperty("IODrawer"), 12);
                vector2.setElementAt(cIMInstance.getProperty("IOSlots"), 13);
                vector2.setElementAt(cIMInstance.getProperty("IORequirement"), 14);
            }
            string = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
            Trace.trace("appphscD", "NewUserDefinedName = " + string);
            if (string5.equals(string)) {
                ((NVRAM)NVRAM.NVRAM_TABLE.get(string3)).saveLPARProfile(string5, string4, vector2, null, hscProviderSocket);
            } else {
                ((NVRAM)NVRAM.NVRAM_TABLE.get(string3)).saveLPARProfile(string5, string4, vector2, string, hscProviderSocket);
            }
            try {
                HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_LPAR_PROFILE_MODIFY", new String[]{"0", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle), "4", "4", Integer.toHexString(s), string4}, hscProviderSocket);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            }
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\nsetInstance - Saved profile to NVRAM");
            }
        }
        catch (Throwable throwable) {
            try {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
                throw new HSCCIMException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
                    if (GlobalConfig.debugLevel((int)3) > 0) {
                        System.out.println("\nsetInstance - Unlocked CSP");
                    }
                    Trace.trace("appphscF", "Unlocked CSP");
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    HSCLogUtils.serverLog(throwable3, HSCLogUtils._ProfileClassLogInfo);
                    throw new HSCCIMException("01F6");
                }
                finally {
                    try {
                        if (hscProviderSocket != null) {
                            hscProviderSocket.releaseLock();
                        }
                        if (GlobalConfig.debugLevel((int)3) > 0) {
                            System.out.println("\nsetInstance - Released LCESocket");
                        }
                        Trace.trace("appphscF", "Released LCESocket");
                    }
                    catch (Throwable throwable4) {
                        HSCLogUtils.serverLog(throwable4, HSCLogUtils._ProfileClassLogInfo);
                    }
                }
            }
        }
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{"2", HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\nsetInstance - Unlocked CSP");
            }
            Trace.trace("appphscF", "Unlocked CSP");
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            throw new HSCCIMException("01F6");
        }
        finally {
            try {
                if (hscProviderSocket != null) {
                    hscProviderSocket.releaseLock();
                }
                if (GlobalConfig.debugLevel((int)3) > 0) {
                    System.out.println("\nsetInstance - Released LCESocket");
                }
                Trace.trace("appphscF", "Released LCESocket");
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            }
        }
        CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance);
        try {
            AsynchEventManager.sendIndication(4, cIMInstance, cIMInstance2);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
        }
        Trace.trace("appphscT", "<- setInstance");
        if (GlobalConfig.debugLevel((int)3) <= 0) return;
        System.out.print("********************************");
        System.out.println("********************************");
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        System.out.print("********************************");
        System.out.println("********************************");
        System.out.println("LPARProfile InternalProvider - execQuery");
        System.out.println("execQuery - CIMObjectPath = " + cIMObjectPath);
        System.out.println("execQuery - String = " + string);
        System.out.println("execQuery - int = " + n);
        Vector vector = CimomWrapper.execQuery((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, string, n, cIMClass);
        System.out.println("execQuery - Return Vector = " + vector);
        System.out.print("********************************");
        System.out.println("********************************");
        return vector;
    }

    public static void deleteProfile(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, String string, String string2, short s, boolean bl, HscProviderSocket hscProviderSocket) throws CIMException {
        Enumeration enumeration;
        Hashtable hashtable = null;
        Enumeration enumeration2 = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        Vector vector = null;
        CIMProperty cIMProperty = null;
        int n = 0;
        Enumeration enumeration3 = null;
        CIMObjectPath cIMObjectPath4 = null;
        CIMObjectPath cIMObjectPath5 = null;
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
            System.out.println("LPARProfileInstProv - deleteProfile");
        }
        Trace.trace("appphscT", "-> deleteProfile");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - CIMOMHandle = " + cIMOMHandle);
        }
        Trace.trace("appphscF", "CIMOMHandle = " + cIMOMHandle);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - CIMOMObjectPath = " + cIMObjectPath);
        }
        Trace.trace("appphscF", "CIMObjectPath = " + cIMObjectPath);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - CIMInstance = " + cIMInstance);
        }
        Trace.trace("appphscF", "CIMInstance = " + cIMInstance);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - CECName = " + string);
        }
        Trace.trace("appphscF", "CECName = " + string);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - SettingID = " + string2);
        }
        Trace.trace("appphscF", "SettingID = " + string2);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - partitionID = " + s);
        }
        Trace.trace("appphscF", "partitionID = " + s);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - broadcastEvent = " + bl);
        }
        Trace.trace("appphscF", "broadcastEvent = " + bl);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - HscProviderConstant = " + hscProviderSocket);
        }
        Trace.trace("appphscF", "HscProviderConstant = " + hscProviderSocket);
        vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getLPARProfile(string2, hscProviderSocket);
        if (vector == null) {
            throw new HSCCIMException("07D3");
        }
        Trace.trace("appphscD", "ret = " + vector);
        vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getDefaultLPARProfile(s, hscProviderSocket);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - ret = " + vector);
        }
        Trace.trace("appphscD", "ret = " + vector);
        if (vector != null) {
            cIMProperty = (CIMProperty)vector.elementAt(0);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ndeleteProfile - cp = " + cIMProperty);
            }
            Trace.trace("appphscD", "cp = " + cIMProperty);
            if (string2.equals((String)cIMProperty.getValue().getValue())) {
                throw new HSCCIMException("07D2");
            }
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ndeleteProfile - Not a default profile");
            }
            Trace.trace("appphscF", "Not a default profile");
        }
        vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getActivatedLPARProfile(s, hscProviderSocket);
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - ret = " + vector);
        }
        Trace.trace("appphscD", "ret = " + vector);
        if (vector != null) {
            cIMProperty = (CIMProperty)vector.elementAt(0);
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ndeleteProfile - cp = " + cIMProperty);
            }
            Trace.trace("appphscD", "cp = " + cIMProperty);
            if (string2.equals((String)cIMProperty.getValue().getValue())) {
                if (GlobalConfig.debugLevel((int)3) > 0) {
                    System.out.println("\ndeleteProfile - Active profile");
                }
                Trace.trace("appphscF", "Active profile");
                hashtable = null;
                hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_STATE", new String[]{Integer.toHexString(s)}, hscProviderSocket);
                if (hashtable == null) {
                    throw new HSCCIMException("05DD");
                }
                n = (Integer)hashtable.get("LPAR_STATE");
                if (GlobalConfig.debugLevel((int)3) > 0) {
                    System.out.println("\ndeleteProfile - LPARState = " + n);
                }
                Trace.trace("appphscD", "LPARState = " + n);
                if (n == 5 || n == 9 || n == 8) {
                    throw new HSCCIMException("07D1");
                }
                hashtable = null;
                hashtable = HscProviderUtils.doCSPCommand("SET_LPAR_SLOT_DEFINITION_STATE", new String[]{Integer.toHexString(s), Integer.toHexString(11)}, hscProviderSocket);
                if (hashtable == null) {
                    throw new HSCCIMException("07D1");
                }
                enumeration3 = CimomWrapper.enumInstances(cIMOMHandle, new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2"), false, new CIMClass("IBMHSC_ActivatedLparProfile")).elements();
                while (enumeration3.hasMoreElements()) {
                    cIMObjectPath5 = (CIMObjectPath)enumeration3.nextElement();
                    cIMObjectPath4 = (CIMObjectPath)cIMOMHandle.getProperty(cIMObjectPath5, "Element").getValue();
                    if (!((String)cIMInstance.getProperty("PartitionName").getValue().getValue()).equals((String)cIMOMHandle.getProperty(cIMObjectPath4, "Name").getValue())) continue;
                    if (GlobalConfig.debugLevel((int)3) > 0) {
                        System.out.println("\ndeleteProfile - Deleting IBMHSC_ActivatedLparProfile " + cIMObjectPath5);
                    }
                    CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath5);
                }
            }
        }
        enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2"), cIMObjectPath, null).elements();
        while (enumeration2.hasMoreElements()) {
            cIMObjectPath2 = (CIMObjectPath)enumeration2.nextElement();
            if (GlobalConfig.debugLevel((int)3) > 0) {
                System.out.println("\ndeleteProfile - Deleting IBMHSC_InSysProfile " + cIMObjectPath2);
            }
            cIMInstance2 = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_InSysProfile"), false);
            cIMObjectPath3 = (CIMObjectPath)cIMInstance2.getProperty("Context").getValue().getValue();
            InSysProfileInstProv.deleteInSysProfile(cIMOMHandle, cIMObjectPath2, string, cIMObjectPath3, string2, s, false, true, hscProviderSocket);
        }
        ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).removeLPARProfile(string2, hscProviderSocket);
        if (bl) {
            try {
                HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_LPAR_PROFILE_DELETE", new String[]{"0", HscProviderUtils.getHscID(cIMOMHandle), "4", "2", Integer.toHexString(s), string2}, hscProviderSocket);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
            }
        }
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.println("\ndeleteProfile - Removed profile from NVRAM");
        }
        if ((enumeration = CimomWrapper.referenceNames(cIMOMHandle, new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2"), cIMObjectPath, null).elements()).hasMoreElements()) {
            CimomWrapper.deleteInstance(cIMOMHandle, (CIMObjectPath)enumeration.nextElement());
        }
        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
        try {
            AsynchEventManager.sendIndication(2, cIMInstance, null);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
        }
        Trace.trace("appphscT", "<- deleteProfile");
        if (GlobalConfig.debugLevel((int)3) > 0) {
            System.out.print("********************************");
            System.out.println("********************************");
        }
    }
}

